/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.mapui;

import filenet.vw.api.VWAssociationDefinition;
import filenet.vw.api.VWMapNode;
import filenet.vw.api.VWRouteDefinition;
import filenet.vw.api.VWTextAnnotationDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.IVWPrintable;
import filenet.vw.toolkit.utils.VWPrinter;
import filenet.vw.toolkit.utils.mapui.IVWSelectWorkflowItem;
import filenet.vw.toolkit.utils.mapui.VWBaseAssociationUI;
import filenet.vw.toolkit.utils.mapui.VWBaseRouteUI;
import filenet.vw.toolkit.utils.mapui.VWBaseStepUI;
import filenet.vw.toolkit.utils.mapui.VWBaseTextAnnotationUI;
import filenet.vw.toolkit.utils.mapui.VWBaseWorkflowPane;
import filenet.vw.toolkit.utils.mapui.VWMap;
import filenet.vw.toolkit.utils.mapui.VWMapAttribs;
import filenet.vw.toolkit.utils.mapui.VWMapColorManager;
import filenet.vw.toolkit.utils.mapui.VWMapItemsEvent;
import filenet.vw.toolkit.utils.mapui.VWRouteArcRender;
import filenet.vw.toolkit.utils.mapui.VWSubmapStepUI;
import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.ItemSelectable;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JViewport;

public abstract class VWBaseWorkflowMapPane
extends JPanel
implements MouseListener,
MouseMotionListener,
ItemListener,
ItemSelectable,
FocusListener,
IVWPrintable,
ComponentListener {
    protected VWBaseWorkflowPane m_workflowPane = null;
    protected VWMap m_map = null;
    protected Vector m_steps = new Vector();
    protected Vector m_routes = new Vector();
    protected Vector m_textAnnotations = new Vector();
    protected Vector m_associations = new Vector();
    protected boolean m_bIsDirty = false;
    protected Vector m_dragItems = null;
    protected Rectangle m_dragRect = null;
    protected Point m_rubberbandStartLoc = null;
    protected Point m_rubberbandStopLoc = null;
    private Point m_dragOffset = null;
    private FontMetrics m_fontMetrics = null;
    private boolean m_bNotifyingSelectionListeners = false;
    protected VWPrinter m_vwPrinter = null;
    protected int m_wPages = 0;
    protected int m_hPages = 0;
    private int m_startingPageNumber = 0;
    protected VWMapColorManager m_colorManager = null;

    public VWBaseWorkflowMapPane(VWBaseWorkflowPane workflowPane) {
        this.m_workflowPane = workflowPane;
        this.setLayout(null);
        this.setDoubleBuffered(true);
        this.setOpaque(true);
        this.m_colorManager = new VWMapColorManager();
        this.setBackground(this.m_colorManager.getColor(1000));
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        workflowPane.addComponentListener(this);
    }

    public boolean getIsDirty() {
        return this.m_bIsDirty;
    }

    public void setIsDirty(boolean bIsDirty) {
        this.m_bIsDirty = bIsDirty;
    }

    public String getMapName() {
        String mapName = null;
        if (this.m_map != null) {
            mapName = this.m_map.getName();
        }
        return mapName;
    }

    public VWMap getMap() {
        return this.m_map;
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.m_fontMetrics == null) {
            this.m_fontMetrics = g.getFontMetrics();
        }
        Enumeration e = this.m_associations.elements();
        while (e.hasMoreElements()) {
            VWBaseAssociationUI association = (VWBaseAssociationUI)e.nextElement();
            association.paintComponent(g);
        }
        e = this.m_textAnnotations.elements();
        while (e.hasMoreElements()) {
            VWBaseTextAnnotationUI textAnnotation = (VWBaseTextAnnotationUI)e.nextElement();
            textAnnotation.paintComponent(g);
        }
        e = this.m_routes.elements();
        while (e.hasMoreElements()) {
            VWBaseRouteUI route = (VWBaseRouteUI)e.nextElement();
            route.paintComponent(g);
        }
        e = this.m_steps.elements();
        while (e.hasMoreElements()) {
            VWBaseStepUI step = (VWBaseStepUI)e.nextElement();
            step.paintComponent(g);
        }
        if (this.m_rubberbandStartLoc != null && this.m_rubberbandStopLoc != null) {
            Rectangle rect = this.createNormalizedRect(this.m_rubberbandStartLoc, this.m_rubberbandStopLoc);
            Color curColor = g.getColor();
            g.setColor(Color.darkGray);
            g.drawRect(rect.x, rect.y, rect.width - 1, rect.height - 1);
            g.setColor(curColor);
        }
        VWPrinter vwPrinter = null;
        VWMapAttribs vwMapAttribs = null;
        if (this.m_workflowPane != null) {
            vwPrinter = this.m_workflowPane.getVWPrinter();
            vwMapAttribs = this.m_workflowPane.getMapAttributes();
        }
        if (vwPrinter != null && vwMapAttribs != null) {
            PageFormat pageFormat = vwPrinter.getPageFormat();
            if (vwMapAttribs.isPageBoundaryVisible() && pageFormat != null) {
                int pageWidth = (int)Math.round(pageFormat.getImageableWidth());
                int pageHeight = (int)Math.round(pageFormat.getImageableHeight());
                if (pageWidth == 0) {
                    pageWidth = 468;
                }
                if (pageHeight == 0) {
                    pageHeight = 648;
                }
                Rectangle bound = this.getBounds();
                int pX = 0;
                int pY = 0;
                int eX = bound.width;
                int eY = bound.height;
                int gapSz = 6;
                int lineSz = 10;
                int segSz = 16;
                g.setColor(SystemColor.activeCaption);
                while (pX < eX) {
                    pX += pageWidth;
                    for (pY = gapSz; pY < eY; pY += segSz) {
                        g.drawLine(pX, pY, pX, pY + lineSz);
                    }
                }
                pX = 0;
                pY = 0;
                while (pY < eY) {
                    pY += pageHeight;
                    for (pX = gapSz; pX < eX; pX += segSz) {
                        g.drawLine(pX, pY, pX + lineSz, pY);
                    }
                }
            }
        }
    }

    public void applyComponentOrientation(ComponentOrientation orientation) {
        Object obj;
        int i;
        super.applyComponentOrientation(orientation);
        if (this.m_steps != null) {
            for (i = 0; i < this.m_steps.size(); ++i) {
                obj = this.m_steps.elementAt(i);
                if (obj == null || !(obj instanceof VWBaseStepUI)) continue;
                ((VWBaseStepUI)obj).setComponentOrientation(orientation);
            }
        }
        if (this.m_textAnnotations != null) {
            for (i = 0; i < this.m_textAnnotations.size(); ++i) {
                obj = this.m_textAnnotations.elementAt(i);
                if (obj == null || !(obj instanceof VWBaseTextAnnotationUI)) continue;
                ((VWBaseTextAnnotationUI)obj).setComponentOrientation(orientation);
            }
        }
    }

    public void removeReferences() {
        Object obj;
        int i;
        this.removeMouseListener(this);
        this.removeMouseMotionListener(this);
        this.m_workflowPane.removeComponentListener(this);
        this.m_workflowPane = null;
        this.m_map = null;
        if (this.m_steps != null) {
            for (i = 0; i < this.m_steps.size(); ++i) {
                obj = this.m_steps.elementAt(i);
                if (obj == null || !(obj instanceof VWBaseStepUI)) continue;
                ((VWBaseStepUI)obj).removeReferences();
            }
            this.m_steps = null;
        }
        if (this.m_routes != null) {
            for (i = 0; i < this.m_routes.size(); ++i) {
                obj = this.m_routes.elementAt(i);
                if (obj == null || !(obj instanceof VWBaseRouteUI)) continue;
                ((VWBaseRouteUI)obj).removeReferences();
            }
            this.m_routes = null;
        }
        if (this.m_textAnnotations != null) {
            for (i = 0; i < this.m_textAnnotations.size(); ++i) {
                obj = this.m_textAnnotations.elementAt(i);
                if (obj == null || !(obj instanceof VWBaseTextAnnotationUI)) continue;
                ((VWBaseTextAnnotationUI)obj).removeReferences();
            }
            this.m_textAnnotations = null;
        }
        if (this.m_associations != null) {
            for (i = 0; i < this.m_associations.size(); ++i) {
                obj = this.m_associations.elementAt(i);
                if (obj == null || !(obj instanceof VWBaseAssociationUI)) continue;
                ((VWBaseAssociationUI)obj).removeReferences();
            }
            this.m_associations = null;
        }
        if (this.m_dragItems != null) {
            this.m_dragItems.removeAllElements();
            this.m_dragItems = null;
        }
        this.m_dragRect = null;
        this.m_rubberbandStartLoc = null;
        this.m_rubberbandStopLoc = null;
        this.m_dragOffset = null;
        this.m_fontMetrics = null;
        this.m_vwPrinter = null;
        this.removeAll();
    }

    public void setFocusStep(int nStepId) {
        if (this.m_steps == null) {
            return;
        }
        for (int nIndex = 0; nIndex < this.m_steps.size(); ++nIndex) {
            if (((VWBaseStepUI)this.m_steps.elementAt(nIndex)).getMapNode().getStepId() != nStepId) continue;
            this.clearAllSelectedItems(false);
            ((VWBaseStepUI)this.m_steps.elementAt(nIndex)).setFocus(true);
            this.notifySelectListeners(true);
            break;
        }
    }

    public abstract void setMapDefinition(VWMap var1);

    public abstract String[] getParentMapNames();

    public void mouseClicked(MouseEvent event) {
        VWSubmapStepUI callStep;
        String mapName;
        int stepType;
        IVWSelectWorkflowItem item = this.getItemAtLocation(event.getPoint());
        this.handleMouseClickOrPressEvent(item);
        if (event.getClickCount() == 2 && item instanceof VWBaseStepUI && ((stepType = ((VWBaseStepUI)item).getStepType()) == 9 || stepType == 10) && (mapName = (callStep = (VWSubmapStepUI)item).getMapName()) != null) {
            this.m_workflowPane.selectMapFromMapCombo(mapName);
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent event) {
        Point point = event.getPoint();
        if (this.m_dragItems == null) {
            IVWSelectWorkflowItem item = this.getItemAtLocation(point);
            if (item != null && (item instanceof VWBaseStepUI || item instanceof VWBaseTextAnnotationUI)) {
                this.handleMouseClickOrPressEvent(item);
                Vector selectedItems = this.getAllSelectedItems();
                this.m_dragItems = new Vector();
                for (int index = 0; index < selectedItems.size(); ++index) {
                    item = (IVWSelectWorkflowItem)selectedItems.elementAt(index);
                    if (!(item instanceof VWBaseStepUI) && !(item instanceof VWBaseTextAnnotationUI)) continue;
                    this.m_dragItems.addElement(item);
                    Rectangle itemRect = null;
                    if (item instanceof VWBaseStepUI) {
                        VWBaseStepUI step = (VWBaseStepUI)item;
                        itemRect = step.getBounds();
                    } else {
                        VWBaseTextAnnotationUI textAnnotation = (VWBaseTextAnnotationUI)item;
                        itemRect = textAnnotation.getBounds();
                    }
                    if (this.m_dragRect == null) {
                        this.m_dragRect = itemRect;
                    } else {
                        if (itemRect.x < this.m_dragRect.x) {
                            this.m_dragRect.width += this.m_dragRect.x - itemRect.x;
                            this.m_dragRect.x = itemRect.x;
                        }
                        if (itemRect.y < this.m_dragRect.y) {
                            this.m_dragRect.width += this.m_dragRect.y - itemRect.y;
                            this.m_dragRect.y = itemRect.y;
                        }
                        if (itemRect.x + itemRect.width > this.m_dragRect.x + this.m_dragRect.width) {
                            this.m_dragRect.width += itemRect.x + itemRect.width - (this.m_dragRect.x + this.m_dragRect.width);
                        }
                        if (itemRect.y + itemRect.height > this.m_dragRect.y + this.m_dragRect.height) {
                            this.m_dragRect.height += itemRect.y + itemRect.height - (this.m_dragRect.y + this.m_dragRect.height);
                        }
                    }
                    this.m_dragOffset = new Point(point.x - this.m_dragRect.x, point.y - this.m_dragRect.y);
                    this.setIsDirty(true);
                }
            } else {
                this.handleMouseClickOrPressEvent(item);
                this.m_rubberbandStartLoc = point;
            }
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (this.m_rubberbandStartLoc != null && this.m_rubberbandStopLoc != null) {
            Rectangle rect = this.createNormalizedRect(this.m_rubberbandStartLoc, this.m_rubberbandStopLoc);
            rect.grow(4, 4);
            this.repaint(rect);
            this.rubberbandSelectSteps(rect);
        }
        this.m_dragItems = null;
        this.m_dragRect = null;
        this.m_dragOffset = null;
        this.m_rubberbandStartLoc = null;
        this.m_rubberbandStopLoc = null;
        JViewport viewport = null;
        Rectangle viewRect = null;
        Point viewPos = null;
        Rectangle oldBounds = null;
        Rectangle newBounds = null;
        if (this.getParent() != null && this.getParent() instanceof JViewport) {
            viewport = (JViewport)this.getParent();
            viewRect = viewport.getBounds();
            viewPos = viewport.getViewPosition();
            oldBounds = this.getBounds();
        }
        this.recalculateBounds(0);
        if (viewport != null) {
            newBounds = this.getBounds();
            if (newBounds.width != oldBounds.width || newBounds.height != oldBounds.height) {
                if (viewPos.x + viewRect.width > newBounds.width) {
                    viewPos.x = newBounds.width - viewRect.width;
                }
                if (viewPos.y + viewRect.height > newBounds.height) {
                    viewPos.y = newBounds.height - viewRect.height;
                }
                viewport.setViewPosition(viewPos);
                this.repaint(new Rectangle(viewPos.x, viewPos.y, viewRect.width, viewRect.height));
            }
        }
    }

    public void mouseDragged(MouseEvent e) {
        if (this.m_dragItems != null) {
            this.doMouseDragSteps(e);
        } else if (this.m_rubberbandStartLoc != null) {
            this.doMouseDragRubberband(e);
        }
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void itemStateChanged(ItemEvent e) {
        if (this.m_bNotifyingSelectionListeners) {
            return;
        }
        this.clearAllSelectedItems(false);
        ItemSelectable itemSel = e.getItemSelectable();
        if (itemSel == null) {
            return;
        }
        Object[] items = itemSel.getSelectedObjects();
        if (items == null) {
            return;
        }
        Rectangle focusRect = null;
        for (int nIndex = 0; nIndex < items.length; ++nIndex) {
            Object object = items[nIndex];
            try {
                VWBaseAssociationUI associationUI;
                VWBaseRouteUI routeUI;
                if (object instanceof VWMapNode) {
                    VWBaseStepUI stepUI = this.findStep((VWMapNode)object);
                    if (stepUI != null) {
                        stepUI.setSelect(true);
                        this.invalidStepRegion(stepUI);
                        if (nIndex == 0) {
                            stepUI.setFocus(true);
                            focusRect = stepUI.getBounds();
                        }
                    }
                } else if (object instanceof VWRouteDefinition && (routeUI = this.findRoute((VWRouteDefinition)object)) != null) {
                    routeUI.setSelect(true);
                    this.repaint(routeUI.getBounds());
                    if (nIndex == 0) {
                        routeUI.setFocus(true);
                        focusRect = routeUI.getBounds();
                    }
                }
                if (object instanceof VWTextAnnotationDefinition) {
                    VWBaseTextAnnotationUI textAnnotationUI = this.findTextAnnotation((VWTextAnnotationDefinition)object);
                    if (textAnnotationUI == null) continue;
                    textAnnotationUI.setSelect(true);
                    this.invalidateTextAnnotationRegion(textAnnotationUI);
                    if (nIndex != 0) continue;
                    textAnnotationUI.setFocus(true);
                    focusRect = textAnnotationUI.getBounds();
                    continue;
                }
                if (!(object instanceof VWAssociationDefinition) || (associationUI = this.findAssociation((VWAssociationDefinition)object)) == null) continue;
                associationUI.setSelect(true);
                this.repaint(associationUI.getBounds());
                if (nIndex != 0) continue;
                associationUI.setFocus(true);
                focusRect = associationUI.getBounds();
                continue;
            }
            catch (ClassCastException ex) {
                VWDebug.logException(ex);
            }
        }
        if (this.getParent() instanceof JViewport && focusRect != null) {
            JViewport viewport = (JViewport)this.getParent();
            Rectangle viewRect = viewport.getViewRect();
            if (focusRect.x < viewRect.x) {
                viewRect.x = focusRect.x;
            } else if (focusRect.x + focusRect.width > viewRect.x + viewRect.width) {
                viewRect.x = focusRect.x + focusRect.width - viewRect.width + 1;
            }
            if (focusRect.y < viewRect.y) {
                viewRect.y = focusRect.y;
            } else if (focusRect.y + focusRect.height > viewRect.y + viewRect.height) {
                viewRect.y = focusRect.y + focusRect.height - viewRect.height + 1;
            }
            viewport.setViewPosition(new Point(viewRect.x, viewRect.y));
        }
    }

    public synchronized void addItemListener(ItemListener l) {
        if (this.m_workflowPane != null) {
            this.m_workflowPane.addItemListener(l);
        }
    }

    public Object[] getSelectedObjects() {
        Object[] objArray = null;
        IVWSelectWorkflowItem focusItem = this.getItemWithFocus();
        Vector selectedItems = this.getAllSelectedItems();
        if (selectedItems != null && selectedItems.size() > 0) {
            Vector<Object> orderedList = new Vector<Object>();
            if (focusItem == null) {
                focusItem = selectedItems.elementAt(0);
            }
            for (int nIndex = 0; nIndex < selectedItems.size(); ++nIndex) {
                Object object = selectedItems.elementAt(nIndex);
                if (focusItem != null && focusItem == object) {
                    if (object instanceof VWBaseStepUI) {
                        orderedList.insertElementAt(((VWBaseStepUI)object).getMapNode(), 0);
                        continue;
                    }
                    if (object instanceof VWBaseRouteUI) {
                        orderedList.insertElementAt(((VWBaseRouteUI)object).getRouteDefinition(), 0);
                        continue;
                    }
                    if (object instanceof VWBaseTextAnnotationUI) {
                        orderedList.insertElementAt(((VWBaseTextAnnotationUI)object).getDefinition(), 0);
                        continue;
                    }
                    if (!(object instanceof VWBaseAssociationUI)) continue;
                    orderedList.insertElementAt(((VWBaseAssociationUI)object).getDefinition(), 0);
                    continue;
                }
                if (object instanceof VWBaseStepUI) {
                    orderedList.addElement(((VWBaseStepUI)object).getMapNode());
                    continue;
                }
                if (object instanceof VWBaseRouteUI) {
                    orderedList.addElement(((VWBaseRouteUI)object).getRouteDefinition());
                    continue;
                }
                if (object instanceof VWBaseTextAnnotationUI) {
                    orderedList.addElement(((VWBaseTextAnnotationUI)object).getDefinition());
                    continue;
                }
                if (!(object instanceof VWBaseAssociationUI)) continue;
                orderedList.addElement(((VWBaseAssociationUI)object).getDefinition());
            }
            objArray = new Object[orderedList.size()];
            orderedList.copyInto(objArray);
        }
        return objArray;
    }

    public synchronized void removeItemListener(ItemListener l) {
        if (this.m_workflowPane != null) {
            this.m_workflowPane.removeItemListener(l);
        }
    }

    public void focusGained(FocusEvent e) {
        if (e.getComponent() instanceof VWBaseRouteUI) {
            this.m_routes.removeElement(e.getComponent());
            this.m_routes.addElement(e.getComponent());
        } else if (e.getComponent() instanceof VWBaseStepUI) {
            this.m_steps.removeElement(e.getComponent());
            this.m_steps.addElement(e.getComponent());
        }
        if (e.getComponent() instanceof VWBaseAssociationUI) {
            this.m_associations.removeElement(e.getComponent());
            this.m_associations.addElement(e.getComponent());
        } else if (e.getComponent() instanceof VWBaseTextAnnotationUI) {
            this.m_textAnnotations.removeElement(e.getComponent());
            this.m_textAnnotations.addElement(e.getComponent());
        }
        this.repaint(e.getComponent().getBounds());
    }

    public void focusLost(FocusEvent e) {
        this.repaint(e.getComponent().getBounds());
    }

    public void bindBook() {
        try {
            int pageCount;
            VWMapAttribs vwMapAttribs = this.m_workflowPane.getMapAttributes();
            if (vwMapAttribs != null && vwMapAttribs.isPrintMap() && (pageCount = this.calculateMapPageCount(this.m_vwPrinter.getPageFormat())) > 0) {
                this.m_vwPrinter.appendBook(this, pageCount);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void printSetup() {
    }

    public void setupVWPrinter(VWPrinter printer) {
        this.m_vwPrinter = printer;
    }

    public int print(Graphics g1, PageFormat pf, int pi) throws PrinterException {
        int status = 1;
        if (pi >= this.m_vwPrinter.getNumberOfPages()) {
            return status;
        }
        Graphics2D g2 = (Graphics2D)g1;
        g2.translate(pf.getImageableX(), pf.getImageableY());
        VWMapAttribs vwMapAttribs = this.m_workflowPane.getMapAttributes();
        if (vwMapAttribs != null && vwMapAttribs.isPrintMap()) {
            this.printMap(g2, pf, pi - this.m_startingPageNumber);
        }
        status = 0;
        return status;
    }

    public void componentHidden(ComponentEvent event) {
    }

    public void componentMoved(ComponentEvent event) {
    }

    public void componentResized(ComponentEvent event) {
        this.recalculateBounds(0);
    }

    public void componentShown(ComponentEvent event) {
    }

    protected void activated() {
        Container parent = this.getParent();
        if (parent != null && parent instanceof JViewport) {
            JViewport viewport = (JViewport)this.getParent();
            this.applyComponentOrientation(viewport.getComponentOrientation());
            this.recalculateBounds(0);
            Dimension extentSize = viewport.getExtentSize();
            Dimension otherExtent = new Dimension((int)extentSize.getWidth() - 1, (int)extentSize.getHeight() - 1);
            viewport.setExtentSize(otherExtent);
            viewport.setExtentSize(extentSize);
            viewport.setViewPosition(new Point(0, 0));
        }
        this.notifyMapActivation();
    }

    protected void bindBook(VWPrinter printer, Graphics theGraphics) {
        this.m_vwPrinter = printer;
        this.m_fontMetrics = theGraphics.getFontMetrics();
        this.m_startingPageNumber = this.m_vwPrinter.getNumberOfPages();
        this.bindBook();
    }

    protected int calculateMapPageCount(PageFormat pf) {
        int totalPages = 0;
        try {
            int lrY;
            int lrX;
            int xMax = 0;
            int yMax = 0;
            Enumeration e = this.m_routes.elements();
            while (e.hasMoreElements()) {
                VWBaseRouteUI route = (VWBaseRouteUI)e.nextElement();
                if (!(route.m_render instanceof VWRouteArcRender)) continue;
                Rectangle routeRect = route.m_render.getBounds();
                int lrX2 = routeRect.x + routeRect.width;
                int lrY2 = routeRect.y + routeRect.height;
                if (xMax < lrX2) {
                    xMax = lrX2;
                }
                if (yMax >= lrY2) continue;
                yMax = lrY2;
            }
            int labelHeight = this.m_fontMetrics.getHeight();
            Enumeration e2 = this.m_steps.elements();
            while (e2.hasMoreElements()) {
                VWBaseStepUI step = (VWBaseStepUI)e2.nextElement();
                String stepName = step.getName();
                lrX = step.getX() + VWBaseStepUI.s_imageDim.width;
                if (stepName != null) {
                    lrX += this.m_fontMetrics.stringWidth(stepName);
                }
                lrY = step.getY() + VWBaseStepUI.s_imageDim.height + labelHeight;
                if (xMax < lrX) {
                    xMax = lrX;
                }
                if (yMax >= lrY) continue;
                yMax = lrY;
            }
            e2 = this.m_textAnnotations.elements();
            while (e2.hasMoreElements()) {
                VWBaseTextAnnotationUI textAnnotationUI = (VWBaseTextAnnotationUI)e2.nextElement();
                Rectangle rect = textAnnotationUI.getBounds();
                lrX = rect.x + rect.width;
                lrY = rect.y + rect.height;
                if (xMax < lrX) {
                    xMax = lrX;
                }
                if (yMax >= lrY) continue;
                yMax = lrY;
            }
            double width = pf.getImageableWidth();
            double height = pf.getImageableHeight();
            this.m_wPages = (int)(((double)xMax + width) / width);
            this.m_hPages = (int)(((double)yMax + height) / height);
            totalPages = this.m_wPages * this.m_hPages;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return totalPages;
    }

    protected boolean clearAllSelectedItems(boolean bNotify) {
        boolean bRetVal = false;
        Vector selectedItems = this.getAllSelectedItems();
        if (selectedItems != null) {
            for (int index = 0; index < selectedItems.size(); ++index) {
                IVWSelectWorkflowItem item = (IVWSelectWorkflowItem)selectedItems.elementAt(index);
                item.setSelect(false);
                this.repaint(((JComponent)((Object)item)).getBounds());
                bRetVal = true;
            }
            if (bNotify) {
                this.notifySelectListeners(false);
            }
        }
        return bRetVal;
    }

    protected VWBaseStepUI findStep(VWMapNode mapNode) {
        for (int index = 0; index < this.m_steps.size(); ++index) {
            if (((VWBaseStepUI)this.m_steps.elementAt(index)).getMapNode() != mapNode) continue;
            return (VWBaseStepUI)this.m_steps.elementAt(index);
        }
        return null;
    }

    protected VWBaseRouteUI findRoute(VWRouteDefinition vwRoute) {
        for (int nIndex = 0; nIndex < this.m_routes.size(); ++nIndex) {
            if (((VWBaseRouteUI)this.m_routes.elementAt(nIndex)).getRouteDefinition() != vwRoute) continue;
            return (VWBaseRouteUI)this.m_routes.elementAt(nIndex);
        }
        return null;
    }

    protected VWBaseTextAnnotationUI findTextAnnotation(VWTextAnnotationDefinition textAnnotation) {
        for (int nIndex = 0; nIndex < this.m_textAnnotations.size(); ++nIndex) {
            if (((VWBaseTextAnnotationUI)this.m_textAnnotations.elementAt(nIndex)).getDefinition() != textAnnotation) continue;
            return (VWBaseTextAnnotationUI)this.m_textAnnotations.elementAt(nIndex);
        }
        return null;
    }

    protected VWBaseAssociationUI findAssociation(VWAssociationDefinition vwAssociationDef) {
        for (int nIndex = 0; nIndex < this.m_associations.size(); ++nIndex) {
            if (((VWBaseAssociationUI)this.m_associations.elementAt(nIndex)).getDefinition() != vwAssociationDef) continue;
            return (VWBaseAssociationUI)this.m_associations.elementAt(nIndex);
        }
        return null;
    }

    protected Vector getAllSelectedItems() {
        int index;
        Vector<IVWSelectWorkflowItem> vector = new Vector<IVWSelectWorkflowItem>();
        for (index = 0; index < this.m_steps.size(); ++index) {
            IVWSelectWorkflowItem step = (IVWSelectWorkflowItem)this.m_steps.elementAt(index);
            if (!step.getSelect()) continue;
            vector.addElement(step);
        }
        for (index = 0; index < this.m_routes.size(); ++index) {
            IVWSelectWorkflowItem route = (IVWSelectWorkflowItem)this.m_routes.elementAt(index);
            if (!route.getSelect()) continue;
            vector.addElement(route);
        }
        for (index = 0; index < this.m_textAnnotations.size(); ++index) {
            IVWSelectWorkflowItem textAnnotation = (IVWSelectWorkflowItem)this.m_textAnnotations.elementAt(index);
            if (!textAnnotation.getSelect()) continue;
            vector.addElement(textAnnotation);
        }
        for (index = 0; index < this.m_associations.size(); ++index) {
            IVWSelectWorkflowItem association = (IVWSelectWorkflowItem)this.m_associations.elementAt(index);
            if (!association.getSelect()) continue;
            vector.addElement(association);
        }
        return vector.size() > 0 ? vector : null;
    }

    protected IVWSelectWorkflowItem getItemAtLocation(Point loc) {
        IVWSelectWorkflowItem item;
        int index;
        for (index = this.m_steps.size() - 1; index >= 0; --index) {
            item = (IVWSelectWorkflowItem)this.m_steps.elementAt(index);
            if (!item.contains(loc)) continue;
            return item;
        }
        for (index = this.m_routes.size() - 1; index >= 0; --index) {
            item = (IVWSelectWorkflowItem)this.m_routes.elementAt(index);
            if (!item.contains(loc)) continue;
            return item;
        }
        for (index = this.m_textAnnotations.size() - 1; index >= 0; --index) {
            item = (IVWSelectWorkflowItem)this.m_textAnnotations.elementAt(index);
            if (!item.contains(loc)) continue;
            return item;
        }
        for (index = this.m_associations.size() - 1; index >= 0; --index) {
            item = (IVWSelectWorkflowItem)this.m_associations.elementAt(index);
            if (!item.contains(loc)) continue;
            return item;
        }
        return null;
    }

    protected IVWSelectWorkflowItem getItemWithFocus() {
        IVWSelectWorkflowItem focusItem;
        if (this.m_steps.size() > 0 && (focusItem = (IVWSelectWorkflowItem)this.m_steps.elementAt(this.m_steps.size() - 1)).getFocus()) {
            return focusItem;
        }
        if (this.m_routes.size() > 0 && (focusItem = (IVWSelectWorkflowItem)this.m_routes.elementAt(this.m_routes.size() - 1)).getFocus()) {
            return focusItem;
        }
        if (this.m_textAnnotations.size() > 0 && (focusItem = (IVWSelectWorkflowItem)this.m_textAnnotations.elementAt(this.m_textAnnotations.size() - 1)).getFocus()) {
            return focusItem;
        }
        if (this.m_associations.size() > 0 && (focusItem = (IVWSelectWorkflowItem)this.m_associations.elementAt(this.m_associations.size() - 1)).getFocus()) {
            return focusItem;
        }
        return null;
    }

    protected void invalidStepRegion(VWBaseStepUI stepUI) {
        VWBaseRouteUI routeUI;
        Rectangle repaintRect = new Rectangle(stepUI.getBounds());
        this.invalidateAssociationRegions(repaintRect, stepUI.getAssociations());
        Enumeration e = stepUI.getPrevRoutes();
        while (e.hasMoreElements()) {
            routeUI = (VWBaseRouteUI)e.nextElement();
            repaintRect.add(routeUI.getBounds());
            this.invalidateAssociationRegions(repaintRect, routeUI.getAssociations());
        }
        e = stepUI.getNextRoutes();
        while (e.hasMoreElements()) {
            routeUI = (VWBaseRouteUI)e.nextElement();
            repaintRect.add(routeUI.getBounds());
            this.invalidateAssociationRegions(repaintRect, routeUI.getAssociations());
        }
        this.repaint(repaintRect);
    }

    protected void invalidateTextAnnotationRegion(VWBaseTextAnnotationUI textAnnotationUI) {
        Rectangle repaintRect = new Rectangle(textAnnotationUI.getBounds());
        this.invalidateAssociationRegions(repaintRect, textAnnotationUI.getAssociations());
        this.repaint(repaintRect);
    }

    protected void invalidateAssociationRegions(Rectangle repaintRect, Enumeration associationEnum) {
        while (associationEnum.hasMoreElements()) {
            VWBaseAssociationUI association = (VWBaseAssociationUI)associationEnum.nextElement();
            repaintRect.add(association.getBounds());
        }
    }

    protected void notifyOfItemsAdded(Object[] items) {
        if (this.m_workflowPane != null) {
            VWMapItemsEvent event = new VWMapItemsEvent(this, 1, items);
            this.m_workflowPane.notifyOfItemsAdded(event);
        }
    }

    protected void notifyOfItemsRemoved(Object[] items) {
        if (this.m_workflowPane != null) {
            VWMapItemsEvent event = new VWMapItemsEvent(this, 2, items);
            this.m_workflowPane.notifyOfItemsRemoved(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void notifySelectListeners(boolean bSelect, boolean bMapActivated) {
        if (this.m_workflowPane == null) return;
        Cursor currentCursor = this.getCursor();
        if (currentCursor == null) {
            currentCursor = Cursor.getDefaultCursor();
        }
        try {
            try {
                this.setCursor(Cursor.getPredefinedCursor(3));
                this.m_bNotifyingSelectionListeners = true;
                int id = 0;
                if (bMapActivated) {
                    id = 100;
                }
                ItemEvent event = new ItemEvent(this, id, this, bSelect ? 1 : 2);
                this.m_workflowPane.notifySelectListeners(event);
                this.m_bNotifyingSelectionListeners = false;
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                Object var7_8 = null;
                this.setCursor(currentCursor);
                return;
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.setCursor(currentCursor);
            throw throwable;
        }
        this.setCursor(currentCursor);
    }

    protected void notifySelectListeners(boolean bSelect) {
        this.notifySelectListeners(bSelect, false);
    }

    protected void notifyMapActivation() {
        this.notifySelectListeners(this.hasSelectedItem(), true);
    }

    protected void recalculateBounds(int buffer) {
        Rectangle minBounds = new Rectangle(10, 10);
        Enumeration e = this.m_steps.elements();
        while (e.hasMoreElements()) {
            VWBaseStepUI step = (VWBaseStepUI)e.nextElement();
            Rectangle stepBounds = step.getBounds();
            stepBounds.grow(20, 20);
            minBounds = minBounds.union(stepBounds);
        }
        e = this.m_textAnnotations.elements();
        while (e.hasMoreElements()) {
            VWBaseTextAnnotationUI textAnnotation = (VWBaseTextAnnotationUI)e.nextElement();
            Rectangle taBounds = textAnnotation.getBounds();
            taBounds.grow(20, 20);
            minBounds = minBounds.union(taBounds);
        }
        if (this.m_rubberbandStartLoc != null && this.m_rubberbandStopLoc != null) {
            if (this.m_rubberbandStartLoc.x < minBounds.x) {
                minBounds.x = this.m_rubberbandStartLoc.x;
            } else if (this.m_rubberbandStartLoc.x > minBounds.x + minBounds.width) {
                minBounds.width += this.m_rubberbandStartLoc.x - (minBounds.x + minBounds.width);
            }
            if (this.m_rubberbandStartLoc.y < minBounds.y) {
                minBounds.y = this.m_rubberbandStartLoc.y;
            } else if (this.m_rubberbandStartLoc.y > minBounds.y + minBounds.height) {
                minBounds.height += this.m_rubberbandStartLoc.y - (minBounds.y + minBounds.height);
            }
            if (this.m_rubberbandStopLoc.x < minBounds.x) {
                minBounds.x = this.m_rubberbandStartLoc.x;
            } else if (this.m_rubberbandStopLoc.x > minBounds.x + minBounds.width) {
                minBounds.width += this.m_rubberbandStopLoc.x - (minBounds.x + minBounds.width);
            }
            if (this.m_rubberbandStopLoc.y < minBounds.y) {
                minBounds.y = this.m_rubberbandStopLoc.y;
            } else if (this.m_rubberbandStopLoc.y > minBounds.y + minBounds.height) {
                minBounds.height += this.m_rubberbandStopLoc.y - (minBounds.y + minBounds.height);
            }
        }
        JViewport viewport = null;
        Point viewportPos = null;
        Container parent = this.getParent();
        if (parent != null && parent instanceof JViewport) {
            viewport = (JViewport)this.getParent();
            viewportPos = viewport.getViewPosition();
            Dimension extentSize = viewport.getExtentSize();
            if (minBounds.width < extentSize.width) {
                minBounds.width = extentSize.width;
            }
            if (minBounds.height < extentSize.height) {
                minBounds.height = extentSize.height;
            }
        }
        Rectangle currentRect = this.getBounds();
        if (minBounds.width == currentRect.width && minBounds.height == currentRect.height) {
            return;
        }
        this.setPreferredSize(new Dimension(minBounds.width, minBounds.height));
        this.setBounds(minBounds);
        if (viewport != null && viewportPos != null) {
            viewport.setViewPosition(viewportPos);
        }
    }

    protected AffineTransform getTransform() {
        if (this.getComponentOrientation().isLeftToRight()) {
            return null;
        }
        AffineTransform flipTransform = new AffineTransform();
        flipTransform.translate((double)this.getWidth() / 2.0, (double)this.getHeight() / 2.0);
        flipTransform.scale(-1.0, 1.0);
        flipTransform.translate((double)(-this.getWidth()) / 2.0, (double)(-this.getHeight()) / 2.0);
        return flipTransform;
    }

    protected void updateStepUI() {
        if (this.m_steps != null) {
            for (int i = 0; i < this.m_steps.size(); ++i) {
                Object obj = this.m_steps.elementAt(i);
                if (obj == null || !(obj instanceof VWBaseStepUI)) continue;
                Rectangle rect = ((VWBaseStepUI)obj).getBounds();
                this.repaint(rect);
            }
        }
    }

    protected void updateRouteUI() {
        if (this.m_routes != null) {
            for (int i = 0; i < this.m_routes.size(); ++i) {
                Object obj = this.m_routes.elementAt(i);
                if (obj == null || !(obj instanceof VWBaseRouteUI)) continue;
                Rectangle rect = ((VWBaseRouteUI)obj).getBounds();
                this.repaint(rect);
            }
        }
    }

    protected void updateTextAnnotationUI() {
        if (this.m_textAnnotations != null) {
            for (int i = 0; i < this.m_textAnnotations.size(); ++i) {
                Object obj = this.m_textAnnotations.elementAt(i);
                if (obj == null || !(obj instanceof VWBaseTextAnnotationUI)) continue;
                this.invalidateTextAnnotationRegion((VWBaseTextAnnotationUI)obj);
            }
        }
    }

    protected void updateAssociationUI() {
        if (this.m_associations != null) {
            for (int i = 0; i < this.m_associations.size(); ++i) {
                Object obj = this.m_associations.elementAt(i);
                if (obj == null || !(obj instanceof VWBaseAssociationUI)) continue;
                Rectangle rect = ((VWBaseAssociationUI)obj).getBounds();
                this.repaint(rect);
            }
        }
    }

    protected void handleMouseClickOrPressEvent(IVWSelectWorkflowItem itemAtLoc) {
        if (itemAtLoc != null) {
            if (!itemAtLoc.getFocus()) {
                IVWSelectWorkflowItem focusItem = this.getItemWithFocus();
                if (focusItem != null) {
                    focusItem.setFocus(false);
                }
                if (!itemAtLoc.getSelect()) {
                    this.clearAllSelectedItems(false);
                } else if (focusItem != null) {
                    focusItem.setSelect(true);
                }
                itemAtLoc.setFocus(true);
                this.notifySelectListeners(true);
            }
        } else {
            this.clearAllSelectedItems(true);
        }
    }

    protected void rubberbandSelectSteps(Rectangle rubberRect) {
        int nIndex;
        VWBaseTextAnnotationUI curFocusTextAnnotation;
        IVWSelectWorkflowItem focusItem = this.getItemWithFocus();
        if (focusItem instanceof VWBaseStepUI) {
            VWBaseStepUI curFocusStep = (VWBaseStepUI)focusItem;
            if (!curFocusStep.getImageBounds().intersects(rubberRect)) {
                focusItem = null;
            }
        } else if (focusItem instanceof VWBaseTextAnnotationUI && !(curFocusTextAnnotation = (VWBaseTextAnnotationUI)focusItem).getBounds().intersects(rubberRect)) {
            focusItem = null;
        }
        boolean bHadSelectedItem = this.clearAllSelectedItems(false);
        Vector<JComponent> selectedItems = new Vector<JComponent>();
        for (nIndex = 0; nIndex < this.m_steps.size(); ++nIndex) {
            VWBaseStepUI stepUI = (VWBaseStepUI)this.m_steps.elementAt(nIndex);
            if (!stepUI.getImageBounds().intersects(rubberRect)) continue;
            stepUI.setSelect(true);
            selectedItems.addElement(stepUI);
        }
        for (nIndex = 0; nIndex < this.m_textAnnotations.size(); ++nIndex) {
            VWBaseTextAnnotationUI textAnnotationUI = (VWBaseTextAnnotationUI)this.m_textAnnotations.elementAt(nIndex);
            if (!textAnnotationUI.getBounds().intersects(rubberRect)) continue;
            textAnnotationUI.setSelect(true);
            selectedItems.addElement(textAnnotationUI);
        }
        if (selectedItems.size() > 0) {
            if (focusItem != null) {
                focusItem.setFocus(true);
            } else {
                IVWSelectWorkflowItem newFocusItem = null;
                for (int nIndex2 = 0; nIndex2 < selectedItems.size(); ++nIndex2) {
                    IVWSelectWorkflowItem potentialFocusItem = (IVWSelectWorkflowItem)selectedItems.elementAt(nIndex2);
                    if (newFocusItem == null) {
                        newFocusItem = potentialFocusItem;
                        continue;
                    }
                    Point loc = newFocusItem.getLocation();
                    double deltaX = loc.x - this.m_rubberbandStopLoc.x;
                    double deltaY = loc.y - this.m_rubberbandStopLoc.y;
                    double focusDist = Math.sqrt(deltaY * deltaY + deltaX * deltaX);
                    loc = potentialFocusItem.getLocation();
                    deltaY = loc.y - this.m_rubberbandStopLoc.y;
                    deltaX = loc.x - this.m_rubberbandStopLoc.x;
                    double potentialDist = Math.sqrt(deltaY * deltaY + deltaX * deltaX);
                    if (!(potentialDist < focusDist)) continue;
                    newFocusItem = potentialFocusItem;
                }
                if (newFocusItem != null) {
                    newFocusItem.setFocus(true);
                }
            }
            for (int nIndex3 = 0; nIndex3 < selectedItems.size(); ++nIndex3) {
                IVWSelectWorkflowItem selectedItem = (IVWSelectWorkflowItem)selectedItems.elementAt(nIndex3);
                if (selectedItem instanceof VWBaseStepUI) {
                    Enumeration assEnum;
                    VWBaseStepUI stepUI = (VWBaseStepUI)selectedItem;
                    Enumeration myEnum = stepUI.getPrevRoutes();
                    while (myEnum.hasMoreElements()) {
                        VWBaseRouteUI routeUI = (VWBaseRouteUI)myEnum.nextElement();
                        if (!selectedItems.contains(routeUI.getSrcStep())) continue;
                        routeUI.setSelect(true);
                        assEnum = routeUI.getAssociations();
                        while (assEnum.hasMoreElements()) {
                            VWBaseAssociationUI associationUI = (VWBaseAssociationUI)assEnum.nextElement();
                            if (!selectedItems.contains(associationUI.getSourceTextAnnotation())) continue;
                            associationUI.setSelect(true);
                        }
                    }
                    myEnum = stepUI.getNextRoutes();
                    while (myEnum.hasMoreElements()) {
                        VWBaseRouteUI routeUI = (VWBaseRouteUI)myEnum.nextElement();
                        if (!selectedItems.contains(routeUI.getDestStep())) continue;
                        routeUI.setSelect(true);
                        assEnum = routeUI.getAssociations();
                        while (assEnum.hasMoreElements()) {
                            VWBaseAssociationUI associationUI = (VWBaseAssociationUI)assEnum.nextElement();
                            if (!selectedItems.contains(associationUI.getSourceTextAnnotation())) continue;
                            associationUI.setSelect(true);
                        }
                    }
                    Enumeration assEnum2 = stepUI.getAssociations();
                    while (assEnum2.hasMoreElements()) {
                        VWBaseAssociationUI associationUI = (VWBaseAssociationUI)assEnum2.nextElement();
                        if (!selectedItems.contains(associationUI.getSourceTextAnnotation())) continue;
                        associationUI.setSelect(true);
                    }
                    this.invalidStepRegion(stepUI);
                    continue;
                }
                if (!(selectedItem instanceof VWBaseTextAnnotationUI)) continue;
                VWBaseTextAnnotationUI textAnnotationUI = (VWBaseTextAnnotationUI)selectedItem;
                this.invalidateTextAnnotationRegion(textAnnotationUI);
            }
            this.notifySelectListeners(true);
        } else if (bHadSelectedItem) {
            this.notifySelectListeners(false);
        }
    }

    private void doMouseDragRubberband(MouseEvent event) {
        Rectangle rect = null;
        Point point = event.getPoint();
        Rectangle bounds = this.getBounds();
        bounds.translate(-bounds.x, -bounds.y);
        if (point.x < bounds.x) {
            point.x = bounds.x;
        }
        if (point.y < bounds.y) {
            point.y = bounds.y;
        }
        if (point.x >= bounds.x + bounds.width) {
            point.x = bounds.x + bounds.width - 1;
        }
        if (point.y >= bounds.y + bounds.height) {
            point.y = bounds.y + bounds.height - 1;
        }
        if (this.m_rubberbandStopLoc != null) {
            rect = this.createNormalizedRect(this.m_rubberbandStartLoc, this.m_rubberbandStopLoc);
            rect.grow(4, 4);
            this.repaint(rect);
        }
        this.m_rubberbandStopLoc = point;
        rect = this.createNormalizedRect(this.m_rubberbandStartLoc, this.m_rubberbandStopLoc);
        rect.grow(4, 4);
        if (this.getParent() instanceof JViewport) {
            JViewport viewport = (JViewport)this.getParent();
            Rectangle viewRect = viewport.getViewRect();
            if (point.x < viewRect.x) {
                viewRect.x = point.x;
            } else if (point.x > viewRect.x + viewRect.width) {
                viewRect.x = point.x - viewRect.width + 1;
            }
            if (point.y < viewRect.y) {
                viewRect.y = point.y;
            } else if (point.y > viewRect.y + viewRect.height) {
                viewRect.y = point.y - viewRect.height + 1;
            }
            viewport.setViewPosition(new Point(viewRect.x, viewRect.y));
        }
        this.repaint(rect);
    }

    private void doMouseDragSteps(MouseEvent event) {
        Point mousePt = null;
        mousePt = event.getPoint();
        Point pt = new Point(mousePt);
        pt.x -= this.m_dragOffset.x;
        pt.y -= this.m_dragOffset.y;
        if (pt.x < 0) {
            pt.x = 0;
        }
        if (pt.y < 0) {
            pt.y = 0;
        }
        int dx = this.m_dragRect.x - pt.x;
        int dy = this.m_dragRect.y - pt.y;
        this.m_dragRect.x = pt.x;
        this.m_dragRect.y = pt.y;
        for (int index = 0; index < this.m_dragItems.size(); ++index) {
            IVWSelectWorkflowItem item = (IVWSelectWorkflowItem)this.m_dragItems.elementAt(index);
            if (item instanceof VWBaseStepUI) {
                VWBaseStepUI step = (VWBaseStepUI)item;
                Point stepPt = step.getLocation();
                stepPt.x -= dx;
                stepPt.y -= dy;
                this.invalidStepRegion(step);
                step.dragTo(stepPt);
                this.invalidStepRegion(step);
                continue;
            }
            if (!(item instanceof VWBaseTextAnnotationUI)) continue;
            VWBaseTextAnnotationUI textAnnotation = (VWBaseTextAnnotationUI)item;
            Point locPt = textAnnotation.getLocation();
            locPt.x -= dx;
            locPt.y -= dy;
            this.invalidateTextAnnotationRegion(textAnnotation);
            textAnnotation.dragTo(locPt);
            this.invalidateTextAnnotationRegion(textAnnotation);
        }
        this.recalculateBounds(0);
        if (this.getParent() instanceof JViewport) {
            if (mousePt.x < 0) {
                mousePt.x = 0;
            }
            if (mousePt.y < 0) {
                mousePt.y = 0;
            }
            JViewport viewport = (JViewport)this.getParent();
            Rectangle viewRect = viewport.getViewRect();
            if (mousePt.x < viewRect.x) {
                viewRect.x = mousePt.x;
            } else if (mousePt.x > viewRect.x + viewRect.width) {
                viewRect.x = mousePt.x - viewRect.width + 20;
            }
            if (mousePt.y < viewRect.y) {
                viewRect.y = mousePt.y;
            } else if (mousePt.y > viewRect.y + viewRect.height) {
                viewRect.y = mousePt.y - viewRect.height + 20;
            }
            viewport.setViewPosition(new Point(viewRect.x, viewRect.y));
        }
    }

    private boolean hasSelectedItem() {
        int nIndex;
        for (nIndex = 0; nIndex < this.m_steps.size(); ++nIndex) {
            IVWSelectWorkflowItem step = (IVWSelectWorkflowItem)this.m_steps.elementAt(nIndex);
            if (!step.getSelect()) continue;
            return true;
        }
        for (nIndex = 0; nIndex < this.m_routes.size(); ++nIndex) {
            IVWSelectWorkflowItem route = (IVWSelectWorkflowItem)this.m_routes.elementAt(nIndex);
            if (!route.getSelect()) continue;
            return true;
        }
        for (nIndex = 0; nIndex < this.m_textAnnotations.size(); ++nIndex) {
            IVWSelectWorkflowItem textAnnotation = (IVWSelectWorkflowItem)this.m_textAnnotations.elementAt(nIndex);
            if (!textAnnotation.getSelect()) continue;
            return true;
        }
        for (nIndex = 0; nIndex < this.m_associations.size(); ++nIndex) {
            IVWSelectWorkflowItem association = (IVWSelectWorkflowItem)this.m_associations.elementAt(nIndex);
            if (!association.getSelect()) continue;
            return true;
        }
        return false;
    }

    private Rectangle createNormalizedRect(Point pt1, Point pt2) {
        int temp;
        Point p1 = new Point(pt1);
        Point p2 = new Point(pt2);
        if (p1.x > p2.x) {
            temp = p1.x;
            p1.x = p2.x;
            p2.x = temp;
        }
        if (p1.y > p2.y) {
            temp = p1.y;
            p1.y = p2.y;
            p2.y = temp;
        }
        return new Rectangle(p1.x, p1.y, p2.x - p1.x, p2.y - p1.y);
    }

    private void printMap(Graphics2D g2, PageFormat pf, int pi) throws PrinterException {
        try {
            Enumeration e = this.m_associations.elements();
            while (e.hasMoreElements()) {
                VWBaseAssociationUI association = (VWBaseAssociationUI)e.nextElement();
                association.printComponent(g2, pf, pi, this.m_wPages, this.m_hPages);
            }
            e = this.m_routes.elements();
            while (e.hasMoreElements()) {
                VWBaseRouteUI route = (VWBaseRouteUI)e.nextElement();
                route.printComponent(g2, pf, pi, this.m_wPages, this.m_hPages);
            }
            e = this.m_textAnnotations.elements();
            while (e.hasMoreElements()) {
                VWBaseTextAnnotationUI textAnnotation = (VWBaseTextAnnotationUI)e.nextElement();
                textAnnotation.printComponent(g2, pf, pi, this.m_wPages, this.m_hPages);
            }
            e = this.m_steps.elements();
            while (e.hasMoreElements()) {
                VWBaseStepUI step = (VWBaseStepUI)e.nextElement();
                step.printComponent(g2, pf, pi, this.m_wPages, this.m_hPages);
            }
        }
        catch (PrinterException ex) {
            throw ex;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

